using System;
using System.Data;
using Method = System.Reflection.MethodBase;
using gov.va.med.vbecs.DAL;
using gov.va.med.vbecs.ExceptionManagement;
using TABLE = gov.va.med.vbecs.Common.VbecsTables.ProductShipper;

namespace gov.va.med.vbecs.BOL
{


		#region Header

		///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
		///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
		///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/28/2002</CreationDate>
		///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
		///<summary>
		///Product Shipper business object layer class. 
		///</summary>

		#endregion

	[Serializable] 
	public class ProductShipper : BaseBusinessObject, IRecordStatusCode 
	{

		#region Variables

		/// <summary>
		/// _drProductShipper
		/// </summary>
		private DataRow _drProductShipper;

		/// <summary>
		/// _dtProductShipper
		/// </summary>
		private DataTable _dtProductShipper;

		/// <summary>
		/// _facilityName
		/// </summary>
		private string _facilityName;

		/// <summary>
		/// _fdaRegistrationNumber
		/// </summary>
		private string _fdaRegistrationNumber;

		#endregion

		# region Constructors

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3060"> 
		///		<ExpectedInput>productShipperGuid, BloodProductGuid</ExpectedInput>
		///		<ExpectedOutput>ProductShipper object</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="3061"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// ProductShipper
		/// </summary>
		/// <param name="productShipperGuid">Product Shipper GUID</param>
		/// <param name="bloodProductGuid">Blood Product GUID</param>
		public ProductShipper(System.Guid productShipperGuid, System.Guid bloodProductGuid) : this(productShipperGuid)
		{
			this.BloodProductGuid = bloodProductGuid;
		}


		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3062"> 
		///		<ExpectedInput>productShipperGuid</ExpectedInput>
		///		<ExpectedOutput>ProductShipper object</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="3063"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Product Shipper
		/// </summary>
		/// <param name="productShipperGuid"></param>
		public ProductShipper(System.Guid productShipperGuid)
		{

			this._dtProductShipper = DAL.ProductShipper.GetProductShipperByGuid(productShipperGuid);

			if (this._dtProductShipper.Rows.Count == 0)
			{
				this.LoadFromDataRow(this._dtProductShipper.NewRow());
				this.ProductShipperGuid = productShipperGuid;
				this.IsNew = true;
				this.IsDirty = true;
			}
			else
			{
				this.LoadFromDataRow(this._dtProductShipper.Rows[0]);
				this.IsNew = false;
				this.IsDirty = false;
			}

		}

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3075"> 
		///		<ExpectedInput>DataRow</ExpectedInput>
		///		<ExpectedOutput>ProductShipper object</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="3086"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// ProductShipper
		/// </summary>
		/// <param name="_dr"></param>
		public ProductShipper(DataRow _dr)
		{

			this.LoadFromDataRow(_dr);
			
			this.IsNew = false;
			this.IsDirty = false;

		}

		#endregion

		#region Properties

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3123"> 
		///		<ExpectedInput>Guid</ExpectedInput>
		///		<ExpectedOutput>Guid</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="3124"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// ProductShipperGuid
		/// </summary>
		public System.Guid ProductShipperGuid
		{
			get
			{
				if (this._drProductShipper.IsNull(TABLE.ProductShipperGuid))
				{
					this._drProductShipper[TABLE.ProductShipperGuid] = System.Guid.NewGuid();
				}
				return (System.Guid)this._drProductShipper[TABLE.ProductShipperGuid];
			}
			set
			{
				this._drProductShipper[TABLE.ProductShipperGuid] = value;
				this.IsDirty = true;
			}
		}

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3125"> 
		///		<ExpectedInput>Common.RecordStatusCode</ExpectedInput>
		///		<ExpectedOutput>Common.RecordStatusCode</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="3126"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// RecordStatusCode
		/// </summary>
		public Common.RecordStatusCode RecordStatusCode
		{
			get
			{
				return Common.Utility.GetRecordStatusCodeFromString(this._drProductShipper[TABLE.RecordStatusCode].ToString());
			}
			set
			{
				this._drProductShipper[TABLE.RecordStatusCode] = Common.Utility.GetRecordStatusCodeCharFromEnum(value);
				this.IsDirty = true;
			}
		}

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3131"> 
		///		<ExpectedInput>Guid</ExpectedInput>
		///		<ExpectedOutput>Guid</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="3319"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// BloodProductGuid
		/// </summary>
		public System.Guid BloodProductGuid
		{
			get
			{
				if (this._drProductShipper.IsNull(TABLE.BloodProductGuid))
				{
					this._drProductShipper[TABLE.BloodProductGuid] = System.Guid.NewGuid();
				}
				return (System.Guid)this._drProductShipper[TABLE.BloodProductGuid];
			}
			set
			{
				this._drProductShipper[TABLE.BloodProductGuid] = value;
				this.IsDirty = true;
			}
		}

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3338"> 
		///		<ExpectedInput>Guid</ExpectedInput>
		///		<ExpectedOutput>Guid</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="3351"> 
		///		<ExpectedInput>Empty Guid</ExpectedInput>
		///		<ExpectedOutput>Broken Rule</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// LocalSupplierGuid
		/// </summary>
		public System.Guid LocalSupplierGuid
		{
			get
			{
				if (this._drProductShipper.IsNull(TABLE.LocalSupplierGuid))
				{
					this._drProductShipper[TABLE.LocalSupplierGuid] = System.Guid.NewGuid();
				}
				return (System.Guid)this._drProductShipper[TABLE.LocalSupplierGuid];
			}
			set
			{
				this._drProductShipper[TABLE.LocalSupplierGuid] = value;

				if (value == System.Guid.Empty)
				{
					RuleBroken(Method.GetCurrentMethod().Name, true);
					return;
				}

				RuleBroken(Method.GetCurrentMethod().Name, false);

				this.GetShipperFacilityDetails();

				this.IsDirty = true;
			}
		}

		
		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3352"> 
		///		<ExpectedInput>Decimal</ExpectedInput>
		///		<ExpectedOutput>Decimal</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="3377"> 
		///		<ExpectedInput>Invalid Decimal</ExpectedInput>
		///		<ExpectedOutput>Broken Rule</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// ProductCost
		/// </summary>
		public Decimal ProductCost
		{
			get
			{
				if (this._drProductShipper.IsNull(TABLE.ProductCost))
				{
					this._drProductShipper[TABLE.ProductCost] = Decimal.Zero;
				}
				return (Decimal)this._drProductShipper[TABLE.ProductCost];
			}
			set
			{

				if (value < 0)
				{
					string errMsg = Common.StrRes.SysErrMsg.Common.RequiredFieldMissing(Common.Utility.ParseStringwithSpaces(Method.GetCurrentMethod().Name, true)).ResString;
					RuleBroken(Method.GetCurrentMethod().Name, true, errMsg);
					return;
				}

				if (value > (decimal)9999.99)
				{
					string errMsg = Common.StrRes.SysErrMsg.Common.CannotbeGreaterError(Common.Utility.ParseStringwithSpaces(
									Method.GetCurrentMethod().Name, true), "9999.99").ResString;
					RuleBroken(Method.GetCurrentMethod().Name, true, errMsg);
					return;
				}

				if (value == 0)
				{
					//The ProductCost can only set to zero by the division iteself for itself. and so on..
					BOL.Division div = new BOL.Division(Common.LogonUser.LogonUserDivisionCode);
					if (div.LocalSupplierGuid != this.LocalSupplierGuid)
					{
						RuleBroken(Method.GetCurrentMethod().Name, true);
						return;
					}
				}

				this._drProductShipper[TABLE.ProductCost] = value;
				RuleBroken(Method.GetCurrentMethod().Name, false);
				this.IsDirty = true;
			}
		}


		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3378"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="3405"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// FacilityName
		/// </summary>
		public string FacilityName
		{
			get
			{
				return this._facilityName;
			}
		}

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3406"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="3407"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// FDA Registration Number
		/// </summary>
		public string FDARegistrationNumber
		{
			get
			{
				return this._fdaRegistrationNumber;
			}
		}

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3408"> 
		///		<ExpectedInput>decimal</ExpectedInput>
		///		<ExpectedOutput>decimal</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="3427"> 
		///		<ExpectedInput>invalid decimal</ExpectedInput>
		///		<ExpectedOutput>broken rule</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// ReturnCreditPercentage
		/// </summary>
		public Decimal ReturnCreditPercentage
		{
			get
			{
				if (this._drProductShipper.IsNull(TABLE.ReturnCreditPercentage))
				{
					this._drProductShipper[TABLE.ReturnCreditPercentage] = Decimal.Zero;
				}
				return (Decimal)this._drProductShipper[TABLE.ReturnCreditPercentage];
			}
			set
			{
				if ((value < 0) || (value > 100))
				{
					string errMsg = Common.StrRes.SysErrMsg.Common.RequiredFieldMissing(Common.Utility.ParseStringwithSpaces(Method.GetCurrentMethod().Name, true)).ResString;
					RuleBroken(Method.GetCurrentMethod().Name, true, errMsg);
					return;
				}

				this._drProductShipper[TABLE.ReturnCreditPercentage] = value;
				RuleBroken(Method.GetCurrentMethod().Name, false);
				this.IsDirty = true;
			}
		}
		

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3428"> 
		///		<ExpectedInput>byte[]</ExpectedInput>
		///		<ExpectedOutput>byte[]</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="3457"> 
		///		<ExpectedInput>invalid array</ExpectedInput>
		///		<ExpectedOutput>ArgumentException</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// RowVersion
		/// </summary>
		public new System.Byte[] RowVersion
		{
			get
			{
				return (byte[]) this._drProductShipper[TABLE.RowVersion];
			}
			set
			{
				if (value == null || value.Length > 8)
				{
					throw new ArgumentException("Invalid RowVersion argument", "value");
				}
				this._drProductShipper[TABLE.RowVersion] = value;
			} 
		}
		#endregion

		#region Methods

		///<Developers>
		///	<Developer></Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/14/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7631"> 
		///		<ExpectedInput>Valid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="7632"> 
		///		<ExpectedInput>Invalid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Insert
		/// </summary>
		/// <param name="lastUpdateFunction"></param>
		/// <returns></returns>
		public bool Insert(Common.UpdateFunction lastUpdateFunction)
		{
			System.Data.DataTable dtInsert = DAL.ProductShipper.GetEmptyProductShipperTable(false);

			System.Data.DataRow dr = dtInsert.NewRow();
			dr[TABLE.BloodProductGuid] = this.BloodProductGuid;
			dr[TABLE.DivisionCode] = Common.LogonUser.LogonUserDivisionCode;
			dr[TABLE.LocalSupplierGuid] = this.LocalSupplierGuid;
			dr[TABLE.ProductCost] = this.ProductCost;
			dr[TABLE.ProductShipperGuid] = this.ProductShipperGuid;
			dr[TABLE.RecordStatusCode] = Common.Utility.GetRecordStatusCodeCharFromEnum(Common.RecordStatusCode.Active);
			dr[TABLE.ReturnCreditPercentage] = this.ReturnCreditPercentage;
			dr[TABLE.LastUpdateUser] = Common.LogonUser.LogonUserName;
			dr[TABLE.LastUpdateFunctionId] = (int)lastUpdateFunction;

			dtInsert.Rows.Add(dr);

			return(DAL.ProductShipper.InsertProductShipper(dtInsert));
		}

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>2/28/2006</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8402"> 
		///		<ExpectedInput>LastupdateFunctionId</ExpectedInput>
		///		<ExpectedOutput>true</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="8403"> 
		///		<ExpectedInput>NA (object with invalid rowversion)</ExpectedInput>
		///		<ExpectedOutput>RowVersionException</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Update
		/// </summary>
		/// <returns></returns>
		public bool Update(Common.UpdateFunction lastUpdateFunctionId)
		{
			//No DAL Method -- ??
			System.Data.DataTable dtUpdate = DAL.ProductShipper.GetEmptyProductShipperTable(true);

			if (this.IsDirty)
			{
				if (this.IsNew)
				{
					return(false);
				}
				else
				{
					dtUpdate.Rows.Add(this.LoadDataRowFromThis(dtUpdate.NewRow()));
				}
			}

			Common.Utility.AppendLastUpdateInformation(dtUpdate, lastUpdateFunctionId);

			int rc = new Common.StoredProcedure().TransactionalGetValue(Common.VbecsStoredProcs.UpdateProductShipper.StoredProcName, dtUpdate);

			return(rc == 0);
		}

		private void GetShipperFacilityDetails()
		{
			DataTable dt = DAL.ProductShipper.GetProductShipperFacilityName(this.LocalSupplierGuid);
			if (dt.Rows.Count == 0)
			{
				this._facilityName = String.Empty;
				this._fdaRegistrationNumber = String.Empty;
			}
			else
			{
				this._facilityName = dt.Rows[0][Common.VbecsTables.LocalSupplier.FacilityName].ToString();
				this._fdaRegistrationNumber = dt.Rows[0][Common.VbecsTables.LocalSupplier.FdaRegistrationNumber].ToString();
			}
		}

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3458"> 
		///		<ExpectedInput>DataRow</ExpectedInput>
		///		<ExpectedOutput>DataRow</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="3506"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// LoadDataRowFromThis
		/// </summary>
		/// <param name="dtRow"></param>
		/// <returns></returns>
		public override System.Data.DataRow LoadDataRowFromThis(System.Data.DataRow dtRow)
		{
			if (dtRow.Table.Columns.Contains(TABLE.ProductShipperGuid))
			{
				dtRow[TABLE.ProductShipperGuid] = this._drProductShipper[TABLE.ProductShipperGuid];
			}

			if (dtRow.Table.Columns.Contains(TABLE.BloodProductGuid))
			{
				dtRow[TABLE.BloodProductGuid] = this._drProductShipper[TABLE.BloodProductGuid];
			}

			if (dtRow.Table.Columns.Contains(TABLE.LocalSupplierGuid))
			{
				dtRow[TABLE.LocalSupplierGuid] = this._drProductShipper[TABLE.LocalSupplierGuid];
			}

			if (dtRow.Table.Columns.Contains(TABLE.ProductCost))
			{
				dtRow[TABLE.ProductCost] = this._drProductShipper[TABLE.ProductCost];
			}

			if (dtRow.Table.Columns.Contains(TABLE.ReturnCreditPercentage))
			{
				dtRow[TABLE.ReturnCreditPercentage] = this._drProductShipper[TABLE.ReturnCreditPercentage];
			}

			if (dtRow.Table.Columns.Contains(TABLE.RecordStatusCode))
			{
				dtRow[TABLE.RecordStatusCode] = this._drProductShipper[TABLE.RecordStatusCode];
			}

			if (dtRow.Table.Columns.Contains(TABLE.DivisionCode))
			{
				dtRow[TABLE.DivisionCode] = this._drProductShipper[TABLE.DivisionCode];
			}

			if (dtRow.Table.Columns.Contains(TABLE.RowVersion))
			{
				dtRow[TABLE.RowVersion] = this._drProductShipper[TABLE.RowVersion];
			}

			return(dtRow);
		}

		/// <summary>
		/// LoadFromDataRow
		/// </summary>
		/// <param name="dtRow"></param>
		/// <returns></returns>
		protected override void LoadFromDataRow(System.Data.DataRow dtRow)
		{

			DataTable dtPsTEmp = DAL.ProductShipper.GetEmptyProductShipperTable(false);
			dtPsTEmp.Columns.Add(TABLE.RowVersion, typeof(byte[]));

			this._drProductShipper = dtPsTEmp.NewRow();

			if (dtRow.Table.Columns.Contains(TABLE.BloodProductGuid))
			{
				if (dtRow.IsNull(TABLE.BloodProductGuid))
				{
					this._drProductShipper[TABLE.BloodProductGuid] = System.Guid.NewGuid();
				}
				else
				{
					this._drProductShipper[TABLE.BloodProductGuid] = dtRow[TABLE.BloodProductGuid];
				}
			}

			if (dtRow.Table.Columns.Contains(TABLE.DivisionCode))
			{
				if (dtRow.IsNull(TABLE.DivisionCode))
				{
					this._drProductShipper[TABLE.DivisionCode] = Common.LogonUser.LogonUserDivisionCode;
				}
				else
				{
					this._drProductShipper[TABLE.DivisionCode] = dtRow[TABLE.DivisionCode];
				}
			}

			if (dtRow.Table.Columns.Contains(TABLE.LastUpdateUser))
			{
				if (dtRow.IsNull(TABLE.LastUpdateUser))
				{
					this._drProductShipper[TABLE.LastUpdateUser] = Common.LogonUser.LogonUserName;
				}
				else
				{
					this._drProductShipper[TABLE.LastUpdateUser] = dtRow[TABLE.LastUpdateUser];
				}
			}

			if (dtRow.Table.Columns.Contains(TABLE.LocalSupplierGuid))
			{
				if (dtRow.IsNull(TABLE.LocalSupplierGuid))
				{
					this._drProductShipper[TABLE.LocalSupplierGuid] = System.Guid.NewGuid();
				}
				else
				{
					this._drProductShipper[TABLE.LocalSupplierGuid] = dtRow[TABLE.LocalSupplierGuid];
				}
				this.GetShipperFacilityDetails();
			}

			if (dtRow.Table.Columns.Contains(TABLE.ProductCost))
			{
				if (dtRow.IsNull(TABLE.ProductCost))
				{
					this._drProductShipper[TABLE.ProductCost] = System.DBNull.Value;
				}
				else
				{
					this._drProductShipper[TABLE.ProductCost] = dtRow[TABLE.ProductCost];
				}
			}

			if (dtRow.Table.Columns.Contains(TABLE.ProductShipperGuid))
			{
				if (dtRow.IsNull(TABLE.ProductShipperGuid))
				{
					this._drProductShipper[TABLE.ProductShipperGuid] = System.Guid.NewGuid();
				}
				else
				{
					this._drProductShipper[TABLE.ProductShipperGuid] = dtRow[TABLE.ProductShipperGuid];
				}
			}

			if (dtRow.Table.Columns.Contains(TABLE.RecordStatusCode))
			{
				if(dtRow.IsNull(TABLE.RecordStatusCode))
				{
					this._drProductShipper[TABLE.RecordStatusCode] = Common.Utility.GetRecordStatusCodeCharFromEnum(Common.RecordStatusCode.Active);
				}
				else
				{
					this._drProductShipper[TABLE.RecordStatusCode] = dtRow[TABLE.RecordStatusCode];
				}
			}

			if (dtRow.Table.Columns.Contains(TABLE.ReturnCreditPercentage))
			{
				if (dtRow.IsNull(TABLE.ReturnCreditPercentage))
				{
					this._drProductShipper[TABLE.ReturnCreditPercentage] = 100;
				}
				else
				{
					this._drProductShipper[TABLE.ReturnCreditPercentage] = dtRow[TABLE.ReturnCreditPercentage];
				}
			}

			if (dtRow.Table.Columns.Contains(TABLE.RowVersion))
			{
				if (!dtRow.IsNull(TABLE.RowVersion))
				{
					this._drProductShipper[TABLE.RowVersion] = (byte[]) dtRow[TABLE.RowVersion];
				}
			}
		}

		///<Developers>
		///	<Developer>Luke Meyer</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/16/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1235"> 
		///		<ExpectedInput>Valid blood product guid and division code</ExpectedInput>
		///		<ExpectedOutput>Valid data table of product Shippers</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2016"> 
		///		<ExpectedInput>Invalid blood product guid</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Returns a DataTable of Product Suppier information for a given BloodProduct GUID and division
		/// </summary>
		/// <param name="bloodProductGuid">GUID</param>
		/// <returns></returns>
		public static DataTable GetProductShippersByDivision(System.Guid bloodProductGuid)
		{
			return DAL.ProductShipper.GetProductShippersByDivision(bloodProductGuid);
		}


		///<Developers>
		///	<Developer>Luke Meyer</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/16/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3507"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>DataTable</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="3587"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Product Shippers LookUpList (by division)
		/// </summary>
		/// <returns></returns>
		public static DataTable GetProductShippersByDivisionLookUpList()
		{
			return DAL.ProductShipper.GetProductShippersByDivisionLookUpList();
		}


		///<Developers>
		///	<Developer>Luke Meyer</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/16/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3588"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>ArrayList</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="3604"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Product Shippers LookUpList (by division)
		/// </summary>
		/// <returns></returns>
		public static System.Collections.ArrayList GetProductShippersByDivisionLookUpAL()
		{

			System.Data.DataTable dt = DAL.ProductShipper.GetProductShippersByDivision(System.Guid.Empty);
			System.Collections.ArrayList al = new System.Collections.ArrayList();
			System.Collections.ArrayList alFilter = new System.Collections.ArrayList();
			foreach(System.Data.DataRow dtRow in dt.Rows)
			{
                BOL.ProductShipper productShipper = new BOL.ProductShipper(dtRow);
				//BR_1.63  Do not show inactive shippers
				if(productShipper.RecordStatusCode == Common.RecordStatusCode.Active)
				{	
					if(!alFilter.Contains(productShipper.FacilityName))
					{
						alFilter.Add(productShipper.FacilityName);
						al.Add(productShipper);
					}
				}
			}
			return al;
		}

		///<Developers>
		///	<Developer>C. Jensen</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/30/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="5710"> 
		///		<ExpectedInput>Valid BloodProduct Guid, LocalSupplier Guid</ExpectedInput>
		///		<ExpectedOutput>decimal</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5711"> 
		///		<ExpectedInput>Invalid BloodProductGuid, LocalSupplier Guid</ExpectedInput>
		///		<ExpectedOutput>0</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// GetReimbursementPercentage
		/// </summary>
		/// <param name="bloodUnitGuid"></param>
		/// <param name="localSupplierGuid"></param>
		/// <returns></returns>
		public static decimal GetReimbursementPercentage(Guid bloodUnitGuid, Guid localSupplierGuid)
		{
			//CR1864 - Changing BloodProductGuid to BloodUnitGuid, so the sproc can check the productguid attached
			//to the unit which could be different than the incoming shipment record has - due to modifications
			return DAL.ProductShipper.GetReimbursementPercentage(bloodUnitGuid, localSupplierGuid);
		}


		#endregion

	}
}

